<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$sql = $conn->prepare("CALL IM_DeudaAnterior(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
$sql->bind_Param("sssssssdisdiisiiiis",$datos[0],$datos[1],$datos[2],$datos[3],$datos[4],$datos[5],$datos[6],$datos[7],$datos[8],
      $datos[9],$datos[10],$datos[11],$datos[12],$datos[13],$datos[14],$datos[15],$datos[16],$datos[17],$datos[18]);

$sql->execute();

if ($datos[18] == "NUEVO") {
    $resultado = array(); // Crear un array para almacenar el resultado

    if ($resultado > 0) {
        $resultado['ESTADO'] = "1";
        $resultado['MENSAJE'] = "LA INFORMACION GUARDO CORRECTAMENTE";
    } else {
        $resultado['ESTADO'] = "0";
        $resultado['MENSAJE'] = "ERROR AL GUADAR LA INFORMACION: " . mysqli_error($conn);
    }

    print_json($resultado);
} else {
    $rows = array();
    
    if ($rows > 0) {
        $resultado['ESTADO'] = "1";
        $resultado['MENSAJE'] = "LA INFORMACION ACTUALIZO CORRECTAMENTE";
    }else{
        $resultado['ESTADO'] = "0";
        $resultado['MENSAJE'] = "ERROR AL ACTUALIZAR LA INFORMACION: ".mysqli_error($conn);   
    }

    print_json($resultado);
}

// Cerrar la conexión a la base de datos
mysqli_close($conn);

function print_json($data) {
    header("HTTP/1.1");
    header("Content-Type: application/json; charset=UTF-8");
    echo json_encode($data, JSON_PRETTY_PRINT);
}
?>