<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST,PUT, GET, DELETE, OPTIONS"); // Add DELETE method here
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

date_default_timezone_set("America/Lima");

$directorioDestino = dirname(__FILE__) . '/pdfs/'; // Ruta relativa al directorio actual del archivo PHP
$enlacesArchivos = array(); // Array para almacenar los enlaces de los archivos subidos

// Obtener el valor del parámetro "ruc de la empresa"
$rucEmpresa = $_POST['ruc_empresa']; // Suponiendo que este valor será enviado desde Java

// Validar si se han enviado archivos
if (!empty($_FILES['archivos']['name'])) {
    // Recorrer cada archivo recibido
    $archivos = $_FILES['archivos'];
    $respuesta = array();

    for ($i = 0; $i < count($archivos['name']); $i++) {
        // Obtener información del archivo actual
        $nombreArchivo = $archivos['name'][$i];
        $tipoArchivo = $archivos['type'][$i];
        $tamanioArchivo = $archivos['size'][$i];
        $tempArchivo = $archivos['tmp_name'][$i];

        // Validar el tipo de archivo permitido
        $tiposPermitidos = array(
            'application/pdf',
            'text/xml',
            'application/xml',
            'application/zip',
            'application/vnd.ms-excel',
            'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
        );

        if (in_array($tipoArchivo, $tiposPermitidos) && $tamanioArchivo > 0 && is_uploaded_file($tempArchivo)) {
            // Construir la ruta de destino basada en el "ruc de la empresa"
            $rutaArchivoDestino = $directorioDestino . $rucEmpresa . '/' . $nombreArchivo;

            // Mover el archivo a su ubicación final
            if (move_uploaded_file($tempArchivo, $rutaArchivoDestino)) {
                // Obtener el enlace del archivo
                $enlaceArchivo = 'https://visioner7.net/pdfs/' . $rucEmpresa . '/' . $nombreArchivo;
                $enlacesArchivos[] = $enlaceArchivo;

                // Agregar información del archivo en la respuesta
                $respuesta[] = array(
                    'nombre' => $nombreArchivo,
                    'status' => 'success',
                    'message' => 'El archivo se ha recibido correctamente.',
                    'enlace' => $enlaceArchivo
                );
            } else {
                // Agregar información del archivo no válido en la respuesta
                $respuesta[] = array(
                    'nombre' => $nombreArchivo,
                    'status' => 'error',
                    'message' => 'Error al mover el archivo. Por favor, intenta nuevamente.'
                );
            }
        } else {
            // Agregar información del archivo no válido en la respuesta
            $respuesta[] = array(
                'nombre' => $nombreArchivo,
                'status' => 'error',
                'message' => 'El archivo no es válido o está vacío.'
            );
        }
    }
} else {
    // Respuesta de error cuando no se envían archivos
    $respuesta = array(
        'status' => 'error',
        'message' => 'No se han enviado archivos.'
    );
}

// Agregar los enlaces de los archivos a la respuesta
$respuesta['enlaces'] = $enlacesArchivos;

// Devolver la respuesta como JSON
header('Content-Type: application/json');
echo json_encode($respuesta);
?>
