<?php
    error_reporting(E_ALL ^ E_NOTICE);
    // Permite la conexion desde cualquier origen
    header("Access-Control-Allow-Origin: *");
    // Permite la ejecucion de los metodos
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
    // Se incluye el archivo que contiene la clase generica
    include_once '../conexion.php';
    $bodyRequest = file_get_contents("php://input");
    // Decodifica el cuerpo de la solicitud y lo guarda en un array de PHP
    $datos = json_decode($bodyRequest, true);
    
    //print_r($datos);
    
    $sql = $conn->prepare("UPDATE almacenes SET principal = ? WHERE id = ?");
    $sql->bind_param("ii", $datos[1], $datos[0]);
    $sql->execute();
    
    // Verificar si la actualizacin fue exitosa
    if ($sql->affected_rows > 0) {
        $response = [
            'status' => 'success',
            'message' => 'Actualizacin exitosa.'
        ];
    } else {
        $response = [
            'status' => 'error',
            'message' => 'No se pudo actualizar el registro.'
        ];
    }
    
    // Cerrar la conexin a la base de datos
    $sql->close();
    $conn->close();
    
    // Devolver la respuesta como un objeto JSON
    header("Content-type: application/json; charset=utf-8");
    echo json_encode($response, JSON_UNESCAPED_UNICODE);

?>