<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

//$sql = "call Anular_Venta($datos[0], $datos[1], $datos[2], $datos[3], $datos[4], $datos[5], $datos[6], $datos[7], $datos[8])";
$sql = $conn->prepare("CALL Anular_Venta(?,?,?,?,?,?,?,?)");
$sql->bind_param("iiiiiiii", ...$datos);

$sql->execute();

$rowsAffected = $sql->affected_rows;

if ($rowsAffected > 0) {
    // Se insertó o actualizó al menos un registro
    print_json(array('ESTADO' => '1', 'MENSAJE' => 'Registro guardado/actualizado con éxito'));
} else {
    // No se insertó ni actualizó ningún registro
    print_json(array('ESTADO' => '0', 'MENSAJE' => 'No se realizaron cambios en la base de datos'));
}

// Cerrar la conexi¨®n a la base de datos
mysqli_close($conn);

function print_json($data) {
    header("HTTP/1.1");
    header("Content-Type: application/json; charset=UTF-8");
    echo json_encode($data, JSON_PRETTY_PRINT);
}
?>